<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:akcus="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v1_0/AKC-US.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v1_0/AKC-US.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="iso-8859-1" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:text>AKC-US</xsl:text> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_AKCS" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_AKCS"> <xsl:for-each select=" ns1:Header|  ns1:* | akcus:*"> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC  NUMER FORMULARZA--> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <!-- SZABLON DOT. POZOSTALI PODATNICY--> <xsl:apply-templates mode="Pozostali" select="."/> <!-- SZABLON DOT. ADRESU WSPÓŁWŁAŚCICELA --> <xsl:apply-templates mode="AdresW" select="."/> <xsl:apply-templates mode="KwotaPodatku" select="."/> <!-- SZABLON DOT. WYROBOW --> <!-- <xsl:apply-templates mode="Wyroby" select="."/> --> <!-- SZABLON DOT. WYROBOW --> <!--<xsl:apply-templates mode="Wyroby1" select="."/>--> <xsl:apply-templates mode="Wyroby2" select="."/> <xsl:apply-templates mode="Razem" select="."/> <!-- SZABLON DOT. OSWIADCZENIE karnej --> <xsl:apply-templates mode="OswKar" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA --> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> <!-- SZABLON DOT. POUCZENIA--> <xsl:apply-templates mode="PouczeniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" colspan="2" height="45" valign="middle" width="586"> <span class="cz12"> <xsl:choose> <xsl:when test="string-length(@identifier)='11'"> <b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> podatnika</b> <sup>1)</sup> </xsl:when> <xsl:otherwise> <b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s> <sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup> </b> </xsl:otherwise> </xsl:choose> </span> </td> <td align="center" colspan="2" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" colspan="1" valign="top"> <td align="left" height="45" valign="top" width="353"/> <td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"> <b>2. Nr dokumentu</b> <br/> <span class="cz16"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"> <b>3. Status</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1"> <xsl:text>AKC-US</xsl:text> </span> </td> </tr> <tr> <!--<td height="61" width="154"/>--> <td width="537"> <div align="center"> <span class="nag1">DEKLARACJA UPROSZCZONA<br/>W SPRAWIE PODATKU AKCYZOWEGO OD SAMOCHODÓW OSOBOWYCH </span> <!--	<span class="nag1"/> --> </div> </td> <!--<td width="243"/>--> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  numeru formularza --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tr> <!--<td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>2. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(.//@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>3. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(//@period,1,4)"/> </div> </td> --> <td width="689"/> <td align="left" valign="top" width="206"> <b> 4. Numer formularza<sup>2)</sup> </b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 106 ust. 2, ust. 3b pkt 1 i ust. 3c pkt 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2020 r. poz. 722, z późn. zm.), zwanej dalej „ustawą”. </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top"> <p>1)	do 14 dni, licząc od dnia powstania obowiązku podatkowego, ale nie później niż w dniu rejestracji samochodu osobowego na terytorium kraju zgodnie z przepisami o ruchu drogowym - w przypadkach, o których mowa w art. 100 ust. 1 pkt 2 oraz art. 100 ust. 1a pkt 2 ustawy;</p> <p>2)	do 14 dni, licząc od dnia powstania obowiązku podatkowego, ale nie później niż w dniu złożenia zawiadomienia zgodnie z przepisami o ruchu drogowym o dokonaniu w pojeździe samochodowym, innym niż samochód osobowy, zarejestrowanym na terytorium kraju, zmian konstrukcyjnych zmieniających rodzaj tego pojazdu na samochód osobowy lub w dniu sprzedaży tego samochodu osobowego, jeżeli jego sprzedaż odbyła się przed dniem złożenia tego zawiadomienia - w przypadku, o którym mowa w art. 100 ust. 1a pkt 1 ustawy.</p> </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top">Urząd skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych podlegających opodatkowaniu podatkiem akcyzowym; jeżeli czynności podlegające opodatkowaniu są wykonywane lub stany faktyczne podlegające opodatkowaniu występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – zgodnie z art. 14 ust. 4-4f ustawy; jeżeli właściwym organem podatkowym jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie, to miejscem składania jest Trzeci Urząd Skarbowy Warszawa-Śródmieście w Warszawie.</td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* |akcus:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <span class="nag1">A.WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="5" width="46"/> <td colspan="2"> <b>5. Naczelnik urzędu skarbowego</b> <br/> <span class="cz18"> <xsl:value-of select="@taxOffice"/> </span> </td> </tr> <tr> <td class="style3" colspan="2"> <b>6. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):  </td> </tr> <tr> <td align="left" valign="top" width="422">1. złożenie deklaracji<br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td align="left" valign="top" width="471">2. korekta deklaracji<sup>3)</sup> <br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/> <!-- <xsl:value-of select="@justification"/> --> </xsl:if> </td> </tr> <tr> <td class="style3" colspan="2"> <b>7. Określenie przedmiotu opodatkowania </b>(zaznaczyć właściwy kwadrat):<br/> <i>W jednej deklaracji może zostać wskazany tylko jeden rodzaj przedmiotu opodatkowania.</i> <p> <xsl:choose> <xsl:when test=".//ns1:SubjectOfTaxation/@optionSubjectOfTaxation='1'"> <b>X </b> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> 1. nabycie wewnątrzwspólnotowe samochodu osobowego, o którym mowa w art. 100 ust. 1 pkt 2 ustawy</p> <p> <xsl:choose> <xsl:when test=".//ns1:SubjectOfTaxation/@optionSubjectOfTaxation='2'"> <b>X </b> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> 2. zmiana konstrukcyjna zmieniająca rodzaj pojazdu na samochód osobowy, o której mowa w art. 100 ust. 1a pkt 1 ustawy</p> <p> <xsl:choose> <xsl:when test=".//ns1:SubjectOfTaxation/@optionSubjectOfTaxation='3'"> <b>X </b> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> 3. nabycie lub posiadanie samochodu osobowego, o których mowa w art. 100 ust. 1a pkt 2 ustawy</p> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE PODATNIKA</span> </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE PODATNIKA </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>8. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat):</td> </tr> <tr> <td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='N'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='F'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>9. Nazwa pełna<sup>4)</sup>/Nazwisko, pierwsze imię<sup>5)</sup> </b> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> --> <span class="cz18"> <xsl:value-of select=".//ns4:PrivatePerson/ns4:BasicData/@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//ns4:PrivatePerson/ns4:BasicData/@firstName"/> </span> <!-- <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> --> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>10. Status podatnika </b>(zaznaczyć właściwy kwadrat):<br/> <i>W jednej deklaracji może zostać wskazany tylko jeden status podatnika. Wskazany status odnosi się do wszystkich wykazanych samochodów osobowych.</i> <br/> <!-- <p> --> <p> <xsl:choose> <xsl:when test=".//ns1:TaxPayer/@TaxPayerStatus='wspolwlasciciel'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b>1.</b>współwłaściciel (W przypadku gdy samochody osobowe są przedmiotem współwłasności dwóch lub więcej podatników   składa się jedną deklarację. Deklaracja obejmuje całkowity podatek akcyzowy do zapłaty zgodnie z art. 106 ust. 3f ustawy)</p> <!-- </p> --> <!-- <p> --> <p> <xsl:choose> <xsl:when test=".//ns1:TaxPayer/@TaxPayerStatus='podmiotOKtorymMowaWArt109Ust3aUstawy'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b>2.</b>podmiot, o którym mowa w art. 109 ust. 3a ustawy</p> <!-- </p> --> <!-- <p> --> <p> <xsl:choose> <xsl:when test=".//ns1:TaxPayer/@TaxPayerStatus='inny'"> <b>X</b> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> <b>3.</b>inny (np. osoba fizyczna będąca jedynym właścicielem)</p> <!-- </p> --> </td> </tr> </table> <!-- <table width="955"> <tr align="right" valign="top"> <td > <span class="nag1"> AKC-US </span> <sub style="cz9">(1)</sub> </td> </tr> </table> --> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | akcus:*"> <!-- Tabelka od nowa --> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <!--	<div style="page-break-before: always"/> --> <table border="1" width="955"> <tr bgcolor="#cccccc"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY<sup>4)</sup>/ ADRES ZAMIESZKANIA<sup>5)</sup> PODATNIKA </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#cccccc" rowspan="3" style="width: 41px;"> </td> <td style="width: 104px;"> <b>11. Kraj </b> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2" style="width: 337px;"> <b>12. Województwo</b> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2" style="width: 419px;"> <b>13. Powiat</b> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="3" style="width: 447px;"> <b>14. Gmina </b> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2" style="width: 419px;"> <b>15. Ulica</b> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> </tr> <tr align="left" valign="top"> <td style="width: 104px;"> <b>16. Nr domu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td style="width: 117px;"> <b>17. Nr lokalu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> <td colspan="2" style="width: 418px;"> <b>18. Miejscowość</b> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td style="width: 164px;"> <b>19. Kod pocztowy</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON ADRES WSPÓŁWŁASCICIELA --> <xsl:template match="*" mode="AdresW"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"/> <xsl:if test="ns1:* | akcus:*"> <xsl:for-each select="//ns1:ItemCoOwner"> <table border="1" width="955"> <tr bgcolor="#cccccc"> <td colspan="6"> <span class="nag2">B.3.<xsl:value-of select="position(  )"/>. DANE PODATNIKA BĘDĄCEGO WSPÓŁWŁAŚCICIELEM (<xsl:value-of select="position(  )"/>)   </span> </td> </tr> <tr> <td bgcolor="#cccccc" rowspan="4" style="width: 41px;"> </td> <td colspan="3" style="width: 104px;"> <b>21. Nazwa pełna<sup>4)</sup>/Nazwisko, pierwsze imię<sup>5)</sup> </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//ns1:CoOwners/ns1:ItemCoOwner/@fullNameCoOwner"/> </span> <!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> --> <span class="cz18"> <xsl:value-of select=".//@surnameCoOwner"/> </span> <span class="cz18"> <xsl:value-of select=".//@firstNameCoOwner"/> </span> </td> <td colspan="2" style="width: 419px;"> <xsl:choose> <xsl:when test="string-length(//@identifierCoOwner)='11'"> <b> <s>22. Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> podatnika</b> <sup>1)</sup> </xsl:when> <xsl:otherwise> <b>22. Identyfikator podatkowy NIP/<s>numer PESEL</s> <sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup> </b> </xsl:otherwise> </xsl:choose> <br/> <span class="cz18"> <xsl:value-of select=".//@identifierCoOwner"/> </span> </td> </tr> <tr align="left" valign="top"> <td style="width: 104px;"> <b>23. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@countryCoOwnerName"/> </span> </td> <td colspan="2"> <b>24. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceCoOwnerName"/> </span> </td> <td colspan="2"> <b>25. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtCoOwnerName"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="3" style="width: 447px;"> <b>26. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeCoOwnerName"/> </span> </td> <td colspan="2" style="width: 419px;"> <b>27. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@streetCoOwner"/> </span> </td> </tr> <tr align="left" valign="top"> <td style="width: 104px;"> <b>28. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumberCoOwner"/> </span> </td> <td style="width: 117px;"> <b>29. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumberCoOwner"/> </span> </td> <td colspan="2" style="width: 418px;"> <b>30. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@cityCoOwner"/> </span> </td> <td style="width: 164px;"> <b>31. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCodeCoOwner"/> </span> </td> </tr> </table> </xsl:for-each> </xsl:if> </xsl:template> <!-- SZABLON POZOSTAŁYCH PODATNIKOW--> <xsl:template match="*" mode="Pozostali"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tr bgcolor="#cccccc"> <td colspan="6"> <span class="nag2">B.3. DANE POZOSTAŁYCH PODATNIKÓW BĘDĄCYCH WSPÓŁWŁAŚCICIELAMI<sup>6)</sup> </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#cccccc" style="width: 41px;"> </td> <td colspan="3" style="width: 716px;"> <b>20. Liczba pozostałych podatników będących współwłaścicielami</b> (poza podatnikiem, o którym mowa w części B.1) <br/> <span class="cz18">  </span> </td> <td align="right" colspan="2" style="width: 176px;"> <span class="cz18"> <xsl:value-of select=".//@noOfOwners"/> </span> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td> <span class="nag1"> AKC-US </span> <sub style="cz9">(1)</sub> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:template match="*" mode="KwotaPodatku"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="4"> <b>C. WYSOKOŚĆ PODATKU AKCYZOWEGO </b> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="40"> <p/> <p/> <p/> <p/> </td> <td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"> <b>Podatek akcyzowy z poz. 53 </b> </td> <td align="left" colspan="2" valign="top" width="283"> <b>32.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalAmountOfTax),'# ##0')"/> </div> <div align="right" class="cz9" valign="bottom">zł</div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" height="46" valign="top"> <b>Zwolnienia i obniżenia </b> </td> <td align="left" colspan="2" valign="top"> <b>33.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@totalAmountOfReductions),'# ##0')"/> </div> <div align="right" class="cz9" valign="bottom">zł</div> </td> </tr> <tr> <td bgcolor="#CCCCCC"> <b>Podatek akcyzowy do zapłaty<sup>7)</sup> </b> <br/> <p>Kwota z poz. 32 pomniejszona o kwotę z poz. 33. Jeżeli różnica jest liczbą ujemną, należy wpisać 0.</p> </td> <td align="left" colspan="2" valign="top"> <b>34.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@toPay),'# ##0')"/> </div> <div align="right" class="cz9" valign="bottom">zł</div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | akcus:*" mode="Wyroby"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"> <!-- <table width="955" border="1"><tr align="right" valign="top"><td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td></tr></table> --> </div> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="7">D. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD POSZCZEGÓLNYCH WYROBÓW AKCYZOWYCH ORAZ SAMOCHODÓW OSOBOWYCH</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td>Lp.</td> <td width="300">Nazwa wyrobów akcyzowych oraz samochodów osobowych, dla których ustalono odrębne stawki podatkowe (w przypadku samochodów osobowych – podać markę, model, rok produkcji, pojemność skokową silnika i nr nadwozia)  </td> <td width="120"> Data powstania obowiązku podatkowego<sup>2)</sup>(dzień-miesiąc-rok)</td> <td width="120">Ośmiocyfrowy kod CN<br/>(dla wyrobów weglowych - pozycja CN)</td> <td width="148">Podstawa <br/>opodatkowania<sup>3) 4) 5)</sup> </td> <td width="79">Stawka podatku </td> <td width="130">Kwota podatku w zł<sup>5)</sup> <br/>(e x f)</td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> <td> <div align="center">e</div> </td> <td> <div align="center">f</div> </td> <td> <div align="center">g</div> </td> </tr> <xsl:for-each select="//ns1:Item"> <tr> <td> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@id"/> </div> </td> <td> <div align="left" class="cz14" valign="top"> <xsl:value-of select="@groupOfGoodsName"/> </div> <xsl:if test="@groupOfGoodsName = 'samochody-osobowe'"> <div align="left" class="cz12" valign="top"> <br/>Marka: <xsl:value-of select="*/@make"/>, Model: <xsl:value-of select="*/@model"/> <br/>Rok produkcji: <xsl:value-of select="*/@yearOfProduction"/>, Pojemność silnika: <xsl:value-of select="*/@capacityOfEngine"/> <br/>Nr ident. VIN (nadwozia/podwozia): <xsl:value-of select="*/@VIN"/> </div> </xsl:if> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="substring(@obligationDate,1,10)"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@valueOfGoods"/> </div> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@numberOfGoods"/> </div> <div align="right" class="cz14" valign="top"> <xsl:value-of select="@unitOfMeasure"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@taxRatePercentage"/> </div> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@taxRate"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> </div> </td> </tr> </xsl:for-each> <tr align="left" valign="top"> <td height="48"/> <td bgcolor="#CCCCCC" colspan="5"> <b>Razem: </b> </td> <td> <b>65.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(.//@sum),'# ##0')"/> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | akcus:*" mode="Wyroby1"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"> <!-- <table width="955" border="1"><tr align="right" valign="top"><td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td></tr></table> --> </div> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td bgcolor="#CCCCCC" class="nag1" colspan="9"> D. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD SAMOCHODÓW OSOBOWYCH</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td> Lp.</td> <td colspan="4" rowspan="1"> Dane pojazdu</td> <td> <p align="center"> Data powstania obowiązku podatkowego<sup>3) </sup> <br/> (dzień-miesiąc-rok)</p> </td> <td> Podstawa opodatkowania<sup>4)</sup> </td> <td> Stawka podatku</td> <td> <p align="center"> Kwota podatku w zł<sup>4)</sup> <br/> (d x e)</p> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td colspan="4" rowspan="1"> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> <td> <div align="center">e</div> </td> <td> <div align="center">f</div> </td> </tr> <xsl:for-each select=".//ns1:Item"> <tr> <td colspan="1" rowspan="8"> <xsl:value-of select="@id"/> </td> <td> <xsl:choose> <xsl:when test=".//@condition='nowy'"> <b>Stan:</b> <br/> nowy /<s> używany</s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@condition='uzywany'"> <b>Stan:</b> <br/> <s>nowy </s> /używany <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:otherwise> <b>Stan:</b> <br/> nowy / używany<sup>(niepotrzebne skreślić)</sup> <i> <xsl:value-of select="@condition"/> </i> </xsl:otherwise> </xsl:choose> </td> <td> <b>Marka:</b> <br/> <br/> <span class="cz14"> <i> <xsl:value-of select="@mark"/> </i> </span> </td> <td> <b>Model:</b> <br/> <br/> <span class="cz14"> <i> <xsl:value-of select="@model"/> </i> </span> </td> <td> <b>Rok produkcji:</b> <br/> <br/> <span class="cz14"> <i> <xsl:value-of select="@yearOfProduction"/> </i> </span> </td> <td rowspan="8"> <span class="cz14"> <xsl:value-of select="substring(@obligationDate,9,2)"/>-<xsl:value-of select="substring(@obligationDate,6,2)"/>-<xsl:value-of select="substring(@obligationDate,1,4)"/> </span> </td> <td colspan="1" rowspan="8"> <span class="cz14"> <xsl:value-of select="@taxBase"/> </span> </td> <td colspan="1" rowspan="8"> <span class="cz14"> <xsl:value-of select="@taxRate"/> </span> </td> <td colspan="1" rowspan="8"> <span class="cz14"> <xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> </span> </td> </tr> <!-- ROK PRODUKCJI NUMER VIN --> <tr> <td colspan="3" rowspan="1"> <xsl:choose> <xsl:when test=".//@VINis='VIN'"> <b>Numer VIN/<s>nadwozia</s>/<s>podwozia</s>/<s>ramy</s> </b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:when test=".//@VINis='nadwozia'"> <b>Numer <s>VIN</s>/nadwozia/<s>podwozia</s>/<s>ramy</s> </b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:when test=".//@VINis='podwozia'"> <b>Numer <s>VIN</s>/<s>nadwozia</s>/podwozia/<s>ramy</s> </b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:when test=".//@VINis='ramy'"> <b>Numer <s>VIN</s>/<s>nadwozia</s>/<s>podwozia</s>/ramy</b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:otherwise> <b>Numer VIN/nadwozia/podwozia/ramy </b> <sup>(niepotrzebne skreślić) </sup>: <br/> <span class="cz14"> <i> <xsl:value-of select="@VINis"/>:</i> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:otherwise> </xsl:choose> </td> <td> <b>Moc silnika w kW:</b> <br/> <span class="cz14"> <i> <xsl:value-of select="@enginePower"/> </i> </span> </td> </tr> <!-- MOC SILNIKA --> <tr> <td> <b>Pojemność silnika</b> <sup>5)</sup>w cm<sup>3</sup>: <br/> <span class="cz14"> <i> <xsl:value-of select="@capacityOfEngine"/> </i> </span> </td> <td colspan="2" rowspan="1"> <b>Przebieg w km</b> <sup>6</sup> <sup>)</sup>: <br/> <span class="cz14"> <i> <xsl:value-of select="@milage"/> </i> </span> </td> <td> <xsl:choose> <xsl:when test=".//@typeOfTransmission='manualna'"> <b> Rodzaj skrzyni biegów:</b> <br/> manualna /<s> automatyczna </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@typeOfTransmission='automatyczna'"> <b> Rodzaj skrzyni biegów:</b> <br/> <s> manualna </s>/ automatyczna <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:otherwise> <b> Rodzaj skrzyni biegów:</b> <br/> manualna/automatyczna <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@typeOfTransmission"/> </i> </span> </xsl:otherwise> </xsl:choose> </td> </tr> <!-- SPOSÓB NAPĘDU --> <tr> <td colspan="4" rowspan="1"> <b>Sposób napędu</b> <sup>(w przypadku wielu sposobów napędu zaznaczyć wszystkie sposoby napędu, np. benzyna i gaz do napędu):</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@driveType"/> </i> </span> <!--	<xsl:choose> <xsl:when test="contains(@driveType,'benzyna')"> <b> Rodzaj skrzyni biegów:</b> <b>Sposób napędu<sup>7</sup> <sup>)</sup>:</b> <br/>olej napędowy / benzyna / energia elektryczna / gaz do napędu / inny <sup>(niepotrzebne skreślić)</sup> <br/> Wybrałeś benzyne </xsl:when> <xsl:when test="contains(@driveType,'gazDoNapedu')"> <b> Rodzaj skrzyni biegów:</b> <b>Sposób napędu<sup>7</sup> <sup>)</sup>:</b> <br/>olej napędowy / benzyna / energia elektryczna / gaz do napędu / inny <sup>(niepotrzebne skreślić)</sup> <br/> Wybrałeś benzyne i gaz do napedu </xsl:when> --> <!--		<xsl:when test="contains(@driveType,'olejNapedowy')"> <b> Rodzaj skrzyni biegów:</b> <b>Sposób napędu<sup>7</sup> <sup>)</sup>:</b> <br/>olej napędowy / benzyna / energia elektryczna / gaz do napędu / inny <sup>(niepotrzebne skreślić)</sup> <br/>OLEJ </xsl:when> <xsl:when test=".//@driveType='energiaelektryczna'"> <b> Rodzaj skrzyni biegów:</b> <b>Sposób napędu<sup>7</sup> <sup>)</sup>:</b> <br/>olej napędowy / benzyna / energia elektryczna / gaz do napędu / inny <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> --> <!--		<xsl:otherwise>  <b>Sposób napędu<sup>7</sup> <sup>)</sup>:</b> <br/>olej napędowy / benzyna / energia elektryczna / gaz do napędu / inny <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@driveType"/> </i> </span> </xsl:otherwise> </xsl:choose> --> </td> </tr> <!-- STAN TECHNICZNY --> <tr> <td colspan="4" rowspan="1"> <xsl:choose> <xsl:when test=".//@technicalCondition='nieuszkodzony'"> <b>Stan techniczny:</b> <br/> nieuszkodzony/ <s>uszkodzony z opinią biegłego</s>/<s> uszkodzony bez opinii biegłego</s> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@technicalCondition='uszkodzonyZOpiniaBieglego'"> <b>Stan techniczny:</b> <br/> <s>nieuszkodzony</s>/ uszkodzony z opinią biegłego/<s> uszkodzony bez opinii biegłego</s> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@technicalCondition='uszkodzonyBezOpiniiBieglego'"> <b>Stan techniczny:</b> <br/> <s> nieuszkodzony</s>/ <s>uszkodzony z opinią biegłego</s>/ uszkodzony bez opinii biegłego<sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:otherwise> <b>Stan techniczny:</b> <br/> nieuszkodzony/ uszkodzony z opinią biegłego/ uszkodzony bez opinii biegłego<sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@technicalCondition"/> </i> </span> </xsl:otherwise> </xsl:choose> </td> </tr> <!-- RODZAJ NADWOZIA --> <tr> <td colspan="4" rowspan="1"> <b>Rodzaj nadwozia</b> <sup>(wskazać jaki)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@bodyCar"/> </i> </span> </td> </tr> <!-- DOWÓD WŁASNOSCI --> <tr> <td colspan="4" rowspan="1"> <xsl:choose> <xsl:when test=".//@proofOfOwnership='fakturaONumerze'"> <b>Dowód własności:</b> <s>umowa sprzedaży </s>/ faktura o numerze <span class="cz14"> <i> <xsl:value-of select="@invoiceNumber"/> </i> </span>/<s> inny </s> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@proofOfOwnership='umowaSprzedazy'"> <b>Dowód własności:</b>umowa sprzedaży /<s> faktura o numerze ................. </s>/ <s>inny </s> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@proofOfOwnership='inny'"> <b>Dowód własności:</b> <s>umowa sprzedaży</s> / <s>faktura o numerze .................</s> / inny <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:otherwise> <b>Dowód własności:</b>umowa sprzedaży / faktura o numerze ................. / inny <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:otherwise> </xsl:choose> </td> </tr> <!-- TYTUŁ ZWOLNIENIA --> <tr> <td colspan="3" rowspan="1"> <xsl:choose> <xsl:when test=".//@resettlementProperty='mieniePrzesiedlenia'"> <b>Tytuł zwolnienia</b> <sup>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </sup> <br/> mienie przesiedlenia / <s>samochód elektryczny lub napędzany wodorem<sup>9)</sup> </s> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>10)</sup> </s>/<s> pozostałe </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodElektryczny_NapedzanyWodorem'"> <b>Tytuł zwolnienia</b> <sup>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </sup> <br/> <s> mienie przesiedlenia</s> / samochód elektryczny lub napędzany wodorem<sup>9)</sup> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>10)</sup> </s>/<s> pozostałe </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodHybrydowyTypuPlug-inDo2000'"> <b>Tytuł zwolnienia</b> <sup>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </sup> <br/> <s>mienie przesiedlenia</s> / <s>samochód elektryczny lub napędzany wodorem<sup>9)</sup> </s> / <s>samochód specjalistyczny</s> / samochód hybrydowy typu plug-in<sup>10)</sup> /<s> pozostałe </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodSpecjalistyczny'"> <b>Tytuł zwolnienia</b> <sup>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </sup> <br/> <s> mienie przesiedlenia </s>/ <s>samochód elektryczny lub napędzany wodorem<sup>9)</sup> </s> / samochód specjalistyczny / <s>samochód hybrydowy typu plug-in<sup>10)</sup> </s>/<s> pozostałe </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='pozostaleZwolnienienia'"> <b>Tytuł zwolnienia</b> <sup>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </sup> <br/> <s>mienie przesiedlenia</s> / <s>samochód elektryczny lub napędzany wodorem<sup>9)</sup> </s> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>10)</sup> </s>/ pozostałe <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:otherwise> <b>Tytuł zwolnienia</b> <sup>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </sup> <br/> mienie przesiedlenia / samochód elektryczny lub napędzany wodorem<sup>9)</sup> / samochód specjalistyczny / samochód hybrydowy typu plug-in<sup>10)</sup> / pozostałe <sup>(niepotrzebne skreślić)</sup> <span class="cz14"/> </xsl:otherwise> </xsl:choose> </td> <td> <b> Liczba pozostałych współwłaścicieli<sup>11)</sup>:</b> <br/> <span class="cz14"> <i> <xsl:value-of select="@noOfOwners"/> </i> </span> </td> </tr> </xsl:for-each> <tr align="left" valign="top"> <td height="48"/> <td bgcolor="#CCCCCC" colspan="6"> <b>Razem: </b> </td> <td colspan="2"> <b>41.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(.//@sum),'# ##0')"/> </div> </td> </tr> </table> </xsl:template> <!-- SZABLON WYROBÓW PO NOWEMU AKC-US --> <xsl:template match="ns1:* | akcus:*" mode="Wyroby2"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td bgcolor="#CCCCCC" class="nag1" colspan="9"> D. OBLICZENIE WYSOKOŚCI PODATKU OD SAMOCHODÓW OSOBOWYCH</td> </tr> <xsl:for-each select=".//ns1:Item"> <tr bgcolor="#cccccc" style="height: 20px;"> <td colspan="6"> <span class="nag2">D.<xsl:value-of select="@id"/>. PODATEK AKCYZOWY OD SAMOCHODU OSOBOWEGO (<xsl:value-of select="@id"/>)</span> </td> </tr> <tr> <td bgcolor="#cccccc" colspan="6" style="text-align: center"> <span class="cz12">Dane pojazdu</span> </td> </tr> <tr> <!-- STAN  --> <td colspan="2" style="width: 657px"> <xsl:choose> <xsl:when test=".//@condition='nowy'"> <b>35. Stan:</b> <br/> nowy /<s> używany</s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@condition='uzywany'"> <b>35. Stan:</b> <br/> <s>nowy </s> /używany <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:otherwise> <b>35. Stan:</b> <br/> nowy / używany<sup>(niepotrzebne skreślić)</sup> <i> <xsl:value-of select="@condition"/> </i> </xsl:otherwise> </xsl:choose> </td> <!-- MARKA --> <td colspan="2"> <b>36. Marka:</b> <br/> <br/> <span class="cz14"> <i> <xsl:value-of select="@mark"/> </i> </span> </td> <!-- MODEL --> <td colspan="2"> <b>37. Model:</b> <br/> <br/> <span class="cz14"> <i> <xsl:value-of select="@model"/> </i> </span> </td> </tr> <tr> <!-- ROK PRODUKCJI --> <td colspan="2"> <b>38. Rok produkcji:</b> <br/> <br/> <span class="cz14"> <i> <xsl:value-of select="@yearOfProduction"/> </i> </span> </td> <!-- NUMER VIN --> <td colspan="2"> <xsl:choose> <xsl:when test=".//@VINis='VIN'"> <b>39. Numer VIN/<s>nadwozia</s>/<s>podwozia</s>/<s>ramy</s> </b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:when test=".//@VINis='nadwozia'"> <b>39. Numer <s>VIN</s>/nadwozia/<s>podwozia</s>/<s>ramy</s> </b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:when test=".//@VINis='podwozia'"> <b>39. Numer <s>VIN</s>/<s>nadwozia</s>/podwozia/<s>ramy</s> </b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:when test=".//@VINis='ramy'"> <b>39. Numer <s>VIN</s>/<s>nadwozia</s>/<s>podwozia</s>/ramy</b> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:when> <xsl:otherwise> <b>39. Numer VIN/nadwozia/podwozia/ramy </b> <sup>(niepotrzebne skreślić) </sup>: <br/> <span class="cz14"> <i> <xsl:value-of select="@VINis"/>:</i> <i> <xsl:value-of select="@VIN"/> </i> </span> </xsl:otherwise> </xsl:choose> </td> <!-- MOC --> <td colspan="2"> <b>40. Moc silnika w kW:</b> <br/> <span class="cz14"> <i> <xsl:value-of select="@enginePower"/> </i> </span> </td> </tr> <tr> <!-- POJEMNOSC --> <td colspan="2"> <b>41. Pojemność silnika</b> <sup>8)</sup>w cm<sup>3</sup>: <br/> <span class="cz14"> <i> <xsl:value-of select="@capacityOfEngine"/> </i> </span> </td> <!-- PRZEBIEG --> <td colspan="2"> <b>42. Przebieg w km</b> <sup>9)</sup> :<br/> <span class="cz14"> <i> <xsl:value-of select="@milage"/> </i> </span> </td> <!-- RODZAJ SKRZYNI --> <td colspan="2"> <xsl:choose> <xsl:when test=".//@typeOfTransmission='manualna'"> <b>43. Rodzaj skrzyni biegów:</b> <br/> manualna /<s> automatyczna </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@typeOfTransmission='automatyczna'"> <b>43. Rodzaj skrzyni biegów:</b> <br/> <s> manualna </s>/ automatyczna <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:otherwise> <b>43. Rodzaj skrzyni biegów:</b> <br/> manualna/automatyczna <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@typeOfTransmission"/> </i> </span> </xsl:otherwise> </xsl:choose> </td> </tr> <tr> <!-- SPOSÓB NAPEDU --> <td colspan="6"> <b>44. Sposób napędu</b> <i>(w przypadku wielu sposobów napędu, zaznaczyć wszystkie sposoby napędu, np. benzyna i gaz do napędu):</i> <br/> hybrydowy typu plug-in<sup>10)</sup> / hybrydowy inny niż typu plug-in<sup>11)</sup> / olej napędowy / benzyna / energia elektryczna / gaz do napędu / wodór / inny <br/> <span class="cz14"> <i> <xsl:value-of select="@driveType"/> </i> </span> </td> </tr> <tr> <!-- STAN TECHNICZNY --> <td colspan="6"> <xsl:choose> <xsl:when test=".//@technicalCondition='nieuszkodzony'"> <b>45. Stan techniczny:</b> <br/> nieuszkodzony/ <s>uszkodzony z opinią rzeczoznawcy</s> <sup>12)</sup>/<s> uszkodzony bez opinii rzeczoznawcy</s> <sup>12)</sup> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@technicalCondition='uszkodzonyZOpiniaBieglego'"> <b>45. Stan techniczny:</b> <br/> <s>nieuszkodzony</s>/ uszkodzony z opinią rzeczoznawcy<sup>12)</sup>/<s> uszkodzony bez opinii rzeczoznawcy</s> <sup>12)</sup> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@technicalCondition='uszkodzonyBezOpiniiBieglego'"> <b>45. Stan techniczny:</b> <br/> <s> nieuszkodzony</s>/ <s>uszkodzony z opinią rzeczoznawcy<sup>12)</sup> </s>/ uszkodzony bez opinii rzeczoznawcy<sup>12)</sup> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:otherwise> <b>45. Stan techniczny:</b> <br/> nieuszkodzony/ uszkodzony z opinią rzeczoznawcy<sup>12)</sup>/ uszkodzony bez opinii rzeczoznawcy<sup>12)</sup> <sup>(niepotrzebne skreślić)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@technicalCondition"/> </i> </span> </xsl:otherwise> </xsl:choose> </td> </tr> <tr> <!-- RODZAJ NADWOZIA --> <td colspan="6"> <b>46. Rodzaj nadwozia:</b> <sup>(wskazać jaki)</sup> <br/> <span class="cz14"> <i> <xsl:value-of select="@bodyCar"/> </i> </span> <br/> </td> </tr> <tr> <!-- DOWÓD WŁASNOSCI --> <td colspan="6"> <xsl:choose> <xsl:when test=".//@proofOfOwnership='fakturaONumerze'"> <b>47. Dowód własności:  </b> <br/> <s>umowa sprzedaży </s>/ faktura o numerze <span class="cz14"> <i> <xsl:value-of select="@invoiceNumber"/> </i> </span>/<s> inny </s> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@proofOfOwnership='umowaSprzedazy'"> <b>47. Dowód własności:  </b> umowa sprzedaży /<s> faktura o numerze ................. </s>/ <s>inny </s> <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:when test=".//@proofOfOwnership='inny'"> <b>47. Dowód własności: </b> <s>umowa sprzedaży</s> / <s> faktura o numerze .................</s> / inny <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:when> <xsl:otherwise> <b>47. Dowód własności:  </b> umowa sprzedaży / faktura o numerze ................. / inny <sup>(niepotrzebne skreślić)</sup> <br/> </xsl:otherwise> </xsl:choose> </td> </tr> <tr> <!-- TYTUL ZWOLNIENIA --> <td colspan="6"> <xsl:choose> <xsl:when test=".//@resettlementProperty='mieniePrzesiedlenia'"> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> mienie przesiedlenia / <s>samochód elektryczny lub napędzany wodorem<sup>13)</sup> </s> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>14)</sup>/<s>samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego</s> <sup>15)</sup> </s>/<s> pozostałe<sup>16)</sup> </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodElektryczny_NapedzanyWodorem'"> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> <s> mienie przesiedlenia</s> / samochód elektryczny lub napędzany wodorem<sup>13)</sup> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>14)</sup>/<s>samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego</s> <sup>15)</sup> </s>/<s> pozostałe<sup>16)</sup> </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodHybrydowyTypuPlug-inDo2000'"> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> <s>mienie przesiedlenia</s> / <s>samochód elektryczny lub napędzany wodorem<sup>13)</sup> </s> / <s>samochód specjalistyczny</s> / samochód hybrydowy typu plug-in<sup>14)</sup>/<s>samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego</s> <sup>15)</sup> /<s> pozostałe<sup>16)</sup> </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodSpecjalistyczny'"> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> <s> mienie przesiedlenia </s>/ <s>samochód elektryczny lub napędzany wodorem<sup>13)</sup> </s> / samochód specjalistyczny / <s>samochód hybrydowy typu plug-in<sup>14)</sup>/<s> samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego</s> <sup>15)</sup> </s>/<s> pozostałe<sup>16)</sup> </s> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='pozostaleZwolnienienia'"> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> <s>mienie przesiedlenia</s> / <s>samochód elektryczny lub napędzany wodorem<sup>13)</sup> </s> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>14)</sup> </s>/ <s>samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego</s> <sup>15)</sup>/ pozostałe<sup>16)</sup> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:when test=".//@resettlementProperty='samochodZTerytoriumUENabytywDrodzezEFTA'"> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> <s>mienie przesiedlenia</s> / <s>samochód elektryczny lub napędzany wodorem<sup>13)</sup> </s> / <s>samochód specjalistyczny</s> / <s>samochód hybrydowy typu plug-in<sup>14)</sup> </s>/ samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego<sup>15)</sup>/<s> pozostałe</s> <sup>16)</sup> <sup>(niepotrzebne skreślić)</sup> </xsl:when> <xsl:otherwise> <b>48. Tytuł zwolnienia</b> <i>(pole wypełnia się wyłącznie w przypadku samochodu osobowego zwolnionego z podatku akcyzowego): </i> <br/> mienie przesiedlenia / samochód elektryczny lub napędzany wodorem<sup>13)</sup> / samochód specjalistyczny / samochód hybrydowy typu plug-in<sup>14)</sup> / samochód przywożony z terytorium UE nabyty w drodze powrotnej z terytorium państwa trzeciego<sup>15)</sup>/ pozostałe<sup>16)</sup> <sup>(niepotrzebne skreślić)</sup> <span class="cz14"/> </xsl:otherwise> </xsl:choose> </td> </tr> <tr> <!-- DATA OBOWIAZKU --> <td bgcolor="#cccccc" colspan="2" style="text-align: center">Data powstania obowiązku podatkowego<sup>17)</sup> <BR/> <i>(dzień-miesiąc-rok)</i> </td> <!-- PODSTAWA OPODATKOWANIA --> <td bgcolor="#cccccc" style="text-align: center">Podstawa opodatkowania<sup>7)</sup> <BR/> </td> <!-- STAWKA --> <td bgcolor="#cccccc" style="text-align: center">Stawka podatku</td> <td bgcolor="#cccccc" colspan="2" style="text-align: center"> Podatek akcyzowy<sup>7)</sup> <BR/> <em>(iloczyn podstawy opodatkowania i stawki podatku)</em> <BR/> </td> </tr> <tr> <td colspan="2"> <b>49.</b> <br/> <div class="cz14" style="text-align: center"> <xsl:value-of select="substring(@obligationDate,9,2)"/>-<xsl:value-of select="substring(@obligationDate,6,2)"/>-<xsl:value-of select="substring(@obligationDate,1,4)"/> </div> </td> <td> <b>50.</b> <br/> <div class="cz14" style="text-align: center"> <xsl:value-of select="@taxBase"/> </div> </td> <td> <b>51.</b> <br/> <div class="cz14" style="text-align: center"> <xsl:value-of select="@taxRate"/> </div> </td> <td colspan="2"> <b>52.</b> <br/> <div class="cz14" style="text-align: right"> <xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> zł </div> </td> </tr> </xsl:for-each> </table> </xsl:if> </xsl:template> <xsl:template match="*" mode="Razem"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tr> <td bgcolor="#cccccc" colspan="4" style="width: 262.25px;" valign="top"> <b>Razem podatek akcyzowy</b> (suma wszystkich pól 52) :</td> <td colspan="2" style="width: 367.75px;"> <b>53.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/> zł </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OŚWIADCZENIA KARNEGO --> <xsl:template match="*" mode="OswKar"> <xsl:if test="ns1:* | akcus:*"> <table border="1" width="955"> <tbody> <tr bgcolor="#cccccc"> <td colspan="6"> <span class="nag1">E. OŚWIADCZENIE O ODPOWIEDZIALNOŚCI KARNEJ<sup>18)</sup> </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#cccccc" style="width: 41px;"> </td> <td colspan="3" style="width: 716px;"> <b>54. Oświadczenie</b> <br/> <xsl:choose> <xsl:when test=".//ns1:TaxPayer/@TaxPayerStatus='wspolwlasciciel'"> <b>X </b> </xsl:when> <xsl:otherwise> <b/>  <b/> </xsl:otherwise> </xsl:choose>Świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia oświadczam, że zostałem upoważniony przez pozostałych współwłaścicieli do złożenia tej deklaracji. <span class="cz18">  </span> </td> </tr> </tbody> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">F. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span> </b> <!--<br/>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.--> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="40"/> <td height="37" width="402"> <b>55. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>56. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="2"> <xsl:choose> <xsl:when test="string-length(//ns3:representative/@repIdentifier)='11'"> <b>57. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> osoby reprezentującej podatnika</b> <sup>1)</sup> </xsl:when> <xsl:otherwise> <b>57. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> osoby reprezentującej podatnika</b> <sup>1)</sup> </xsl:otherwise> </xsl:choose> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repIdentifier"/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>58. Data wypełnienia deklaracji</b> (dzień – miesiąc – rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> <td> <b>59. Podpis podatnika lub osoby reprezentującej podatnika </b> <br/> <br/> <xsl:if test="//@amount"> <span class="cz18"> <i>Formularz  podpisany za pomocą danych autoryzujących</i> </span> <br/> </xsl:if> </td> </tr> <tr align="left" valign="top"> <td colspan="3"> <b>60. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@phone"/> </span> <span class="cz18"> <xsl:value-of select="//@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3" height="36"> <span class="nag1">G. ADNOTACJE URZĘDU SKARBOWEGO<sup>19)</sup> </span> <br/> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>61. Uwagi urzędu skarbowego <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>62. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>63. Podpis przyjmującego formularz </b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA --> <xsl:template match="*" mode="ObjasnieniaAkc"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia</b> </p> <sup>1)</sup>	    Numer PESEL należy podać w przypadku osób fizycznych objętych rejestrem PESEL nieprowadzących działalności gospodarczej lub niebędących zarejestrowanymi podatnikami podatku od towarów i usług.<br/> <sup>2)</sup>		W przypadku gdy deklaracja jest składana w postaci papierowej, a samochody osobowe w niej wykazane są przedmiotem współwłasności więcej niż czterech współwłaścicieli, należy wypełnić kolejny formularz deklaracji AKC-US i wskazać jego numer w ogólnej liczbie składanych formularzy. W takim przypadku części C i D wypełnia się tylko w formularzu numer 1. W przypadku deklaracji składanych za pomocą środków komunikacji elektronicznej wszystkich współwłaścicieli wskazuje się w jednym formularzu.<br/> <sup>3)</sup>		Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2020 r. poz. 1325, z późn. zm.).<br/> <sup>4)</sup>		Dotyczy podatników niebędących osobami fizycznymi.<br/> <sup>5)</sup>		Dotyczy podatników będących osobami fizycznymi.<br/> <sup>6)</sup>		Część należy wypełnić w przypadku zaznaczenia kwadratu nr 1 w poz. 10 (po zapoznaniu się z objaśnieniem numer 2).<br/> <sup>7)</sup>		Podstawy opodatkowania (wyrażone kwotowo) i kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa.<br/> <sup>8)</sup>		W przypadku gdy ten parametr nie ma zastosowania należy wpisać 0.<br/> <sup>9)</sup>		Przebieg pojazdu zaokrągla się z dokładnością do 1000 km w ten sposób, że ostatnie trzy cyfry wynoszące 500 i więcej kilometrów zaokrągla się w górę do pełnego tysiąca, zaś ostatnie trzy cyfry wynoszące poniżej 500 kilometrów zaokrągla się w dół do pełnego tysiąca.<br/> <sup>10)</sup>		Dotyczy samochodów osobowych o napędzie spalinowo-elektrycznym, w którym energia elektryczna jest akumulowana przez podłączenie do zewnętrznego źródła zasilania.<br/> <sup>11)</sup>		Dotyczy samochodów osobowych o napędzie spalinowo-elektrycznym, w którym energia elektryczna jest akumulowana w inny sposób niż przez podłączenie do zewnętrznego źródła zasilania.<br/> <sup>12)</sup>		Zgodnie z przepisami ustawy z 20 czerwca 1997 r. – Prawo o ruchu drogowym (Dz. U. z 2021 r. poz. 450, z późn. zm.).<br/> <sup>13)</sup>		Zwolnienie dla samochodów osobowych stanowiących pojazd elektryczny i pojazd napędzany wodorem, zgodnie z art. 109a ustawy.<br/> <sup>14)</sup>		Zwolnienie dla samochodów osobowych stanowiących pojazd hybrydowy o pojemności silnika spalinowego nie większej niż 2000 centymetrów sześciennych, zgodnie z art. 163a ustawy.<br/> <sup>15)</sup>		Zwolnienie dla samochodów osobowych, o którym mowa w art. 112 ust. 3 ustawy.<br/> <sup>16)</sup>		Np. zwolnienie dla samochodów osobowych, o którym mowa w art. 110 ust. 4 ustawy.<br/> <sup>17)</sup>		Datę powstania obowiązku podatkowego określa się odpowiednio na podstawie art. 101 ust. 2 i 4a ustawy.<br/> <sup>18)</sup>		Oświadczenie dotyczy przypadku gdy zaznaczono kwadrat nr 1 w poz. 10.<br/> <sup>19)</sup>		Część nie jest wypełniana w przypadku otrzymania przez urząd skarbowy dokumentu w postaci elektronicznej.<br/> <br/> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. POUCZENIA--> <xsl:template match="*" mode="PouczeniaAkc"> <table width="955"> <tr> <td> <p align="center"> <b>Pouczenia</b> </p> <p>W przypadku niewpłacenia w obowiązującym terminie podatku z poz. 34 lub wpłacenia go w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2020 r. poz. 1427, z późn. zm.).</p> <p>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> AKC-US </span> <sub style="cz9">(1)</sub> </td> </tr> </table> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet> 